 aR  w Q mP9      h	 oP       nSystem-wide$SYMBOLSPACE (24)
$COMPACT
$NOLIST

MODULE CtrlRtns;

{ $INCLUDE (``Inc_PadP`Con_Pas~Inc~) }

$INCLUDE (``Inc_PadP`Common~Inc~)
$INCLUDE (``Inc_PadP`Windows~Inc~)
$INCLUDE (``Inc_PadP`Controls~Inc~)

{ These should eventually go into their own include files for GRiDPad }

PUBLIC NewOverlayRoutines;
  PROCEDURE OvlGetPt
   (VAR x: Integer; VAR y: Integer; VAR penDown: Boolean; VAR error: Word);

PUBLIC InternalWindows;
  PROCEDURE WinDrawCircle (topLeftX, topLeftY, diameter: Integer);
  PROCEDURE WinDrawCircleFrame (topLeftX, topLeftY, diameter: Integer);
  PROCEDURE WinInvertCircleFrame (topLeftX, topLeftY, diameter: Integer);

{--------------------------------------------------------}
{                         Locals                         }
{--------------------------------------------------------}

PRIVATE CtrlRtns;
CONST
  buttonArc   = 10;

{--------------------------------------------------------}
{                     CtlInitControl                     }
{--------------------------------------------------------}

PROCEDURE CtlInitControl
 (VAR control: ControlRecd; controlType: Word;
  initValue, loValue, hiValue: Integer; usersData: LongInt;
  VAR r: Rectangle; pText: TextPtr; textLength: Word);
BEGIN
WITH control DO
  BEGIN
  visible := FALSE;
  active := TRUE;
  ctrlType := controlType;
  value := initValue;
  minValue := loValue;
  maxValue := hiValue;
  userData := usersData;
  rect := r;
  text := pText;
  textLen := textLength;
  END;
END;

{--------------------------------------------------------}
{                   CtlFreeControlInfo                   }
{--------------------------------------------------------}

PROCEDURE CtlFreeControlInfo (VAR control: ControlRecd);
BEGIN
  ;  { This routine may be needed by other types of controls }
END;

{--------------------------------------------------------}
{                    CtlEnableControl                    }
{--------------------------------------------------------}

PROCEDURE CtlEnableControl (VAR control: ControlRecd);
BEGIN
control.active := TRUE;
END;

{--------------------------------------------------------}
{                    CtlDisableControl                   }
{--------------------------------------------------------}

PROCEDURE CtlDisableControl (VAR control: ControlRecd);
BEGIN
control.active := FALSE;
END;

{--------------------------------------------------------}
{                   CtlSetControlValue                   }
{--------------------------------------------------------}

PROCEDURE CtlSetControlValue (VAR control: ControlRecd; newValue: Integer);
BEGIN
WITH control DO
  BEGIN
  IF newValue <= minValue THEN
    value := minValue
  ELSE IF newValue >= maxValue THEN
    value := maxValue
  ELSE
    value := newValue;
  END;
END;

{--------------------------------------------------------}
{                     CtlDrawControl                     }
{--------------------------------------------------------}

PROCEDURE CtlDrawControl (VAR control: ControlRecd);
VAR
  x1,y1,x2,y2: Integer;
  buttonSize:  Integer;
  buttonInset: Integer;
  drawX,drawY: Integer;
  r:           Rectangle;
  saveClip:    Rectangle;

BEGIN
WITH control DO
  BEGIN
  visible := TRUE;
  r := rect;
  IF (ctrlType = buttonCtrl) OR
     (ctrlType = invButtonCtrl) OR
     (ctrlType = a3dButtonCtrl) THEN
    BEGIN
    IF ctrlType = buttonCtrl THEN
      WinDrawRectangleFrame (simpleFrame, rect, buttonArc)
    ELSE IF ctrlType = a3dButtonCtrl THEN
      WinDrawRectangleFrame (se3DShadow2, rect, 0);
    drawX := rect.topLeft.x +
             ((rect.extent.x + 1 - FntCharsWidth (text^, textLen)) DIV 2);
    drawY := rect.topLeft.y + ((rect.extent.y + 1 - FntCharHeight) DIV 2);
    WinGetClip (saveClip);
    WinSetClip (r);
    IF active THEN
      WinDrawChars (text^, textLen, drawX, drawY)
    ELSE
      WinDrawGrayChars (text^, textLen, drawX, drawY);
    WinSetClip (saveClip);
    END
  ELSE IF (ctrlType = checkBoxCtrl) OR (ctrlType = radioCtrl) THEN
    BEGIN
    r.extent.x := rect.extent.y;
    IF (ctrlType = checkBoxCtrl) THEN
      BEGIN
      RctInsetRectangle (r, 1);
      WinDrawRectangleFrame (simpleFrame, r, 0);
      x1 := rect.topLeft.x + 1;
      y1 := rect.topLeft.y + 1;
      x2 := x1 + rect.extent.y - 3;
      y2 := y1 + rect.extent.y - 3;
      IF value = minValue THEN
        BEGIN
        WinEraseLine (x1, y1, x2, y2);
        WinEraseLine (x2, y1, x1, y2);
        END
      ELSE
        BEGIN
        WinDrawLine (x1, y1, x2, y2);
        WinDrawLine (x2, y1, x1, y2);
        END;
      END
    ELSE
      BEGIN
      WinEraseRectangle (r, 0);
      WinDrawCircleFrame (r.topLeft.x, r.topLeft.y, r.extent.x);
      IF value <> 0 THEN { If control should not be off... }
        BEGIN
        buttonSize  := rect.extent.y DIV 2;
        buttonInset := (buttonSize + 1) DIV 2;
        WinDrawCircle (rect.topLeft.x + buttonInset,
                       rect.topLeft.y + buttonInset, buttonSize);
        END;
      END;
    drawX := rect.topLeft.x + rect.extent.y + FntAverageCharWidth;
    drawY := rect.topLeft.y + ((rect.extent.y + 1 - FntCharHeight) DIV 2);
    WinGetClip (saveClip);
    WinSetClip (rect);
    IF active THEN
      WinDrawChars (text^, textLen, drawX, drawY)
    ELSE
      WinDrawGrayChars (text^, textLen, drawX, drawY);
    WinSetClip (saveClip);
    END;
  END;
END;

{--------------------------------------------------------}
{                   CtlControlPressed                    }
{--------------------------------------------------------}

{ This routine expects to be called whenever a pen down  }
{ event occurs inside the rectangle of the control being }
{ passed.  Just to be nice, I will verify that the pen   }
{ down did occur inside of the rectangle of the control. }

FUNCTION CtlControlPressed
 (VAR control: ControlRecd; x, y: Integer): Boolean;
VAR
  lastIn:       Boolean;
  penDown:      Boolean;
  ctrlPressed:  Boolean;
  firstTime:    Boolean;
  hilighted:    Boolean;
  error:        Word;

BEGIN
ctrlPressed := FALSE;
hilighted := FALSE;
WITH control DO
  BEGIN
  IF (active) AND (visible) THEN
    BEGIN
    IF RctPtInRectangle (x, y, rect) THEN
      BEGIN
      penDown := TRUE;
      lastIn := TRUE;
      firstTime := TRUE;
      error := 0;
      REPEAT
        BEGIN
        IF NOT firstTime THEN
          OvlGetPt (x, y, penDown, error);
        IF RctPtInRectangle (x, y, rect) THEN
          BEGIN
          IF penDown THEN
            BEGIN
            IF NOT hilighted THEN
              BEGIN
              hilighted := TRUE;
              InvertControlHilight (ctrlType, value, rect);
              END;
            END
          ELSE { pen is up }
            BEGIN
            IF hilighted THEN
              BEGIN
              { Don't need to reset if exiting routine }
              { hilighted := FALSE; }
              InvertControlHilight (ctrlType, value, rect);
              ctrlPressed := TRUE;
              END;
            END;
          lastIn := TRUE;
          END
        ELSE
          BEGIN
          IF hilighted THEN
            BEGIN
            hilighted := FALSE;
            InvertControlHilight (ctrlType, value, rect);
            END;
          ctrlPressed := lastIn;
          lastIn := FALSE;
          END;
        firstTime := FALSE
        END;
      UNTIL (NOT penDown) OR (error <> 0);
      END;
    END;
  END;
CtlControlPressed := ctrlPressed;
END;

{--------------------------------------------------------}
{                  InvertControlHilight                  }
{--------------------------------------------------------}

PROCEDURE InvertControlHilight (ctrlType, value: Integer; VAR rect: Rectangle);
VAR
  leftX, rightX: Integer;
  topY, bottomY: Integer;

BEGIN
IF ctrlType = buttonCtrl THEN
  BEGIN
  WinInvertRectangle (rect, buttonArc);
  END
ELSE IF (ctrlType = invButtonCtrl) OR (ctrlType = a3dButtonCtrl) THEN
  BEGIN
  WinInvertRectangle (rect, 0);
  END
ELSE IF ctrlType = checkBoxCtrl THEN
  BEGIN
  leftX := rect.topLeft.x + 1;
  topY := rect.topLeft.y + 1;
  rightX := leftX + rect.extent.y - 3;
  bottomY := topY + rect.extent.y - 3;
  WinInvertLine (leftX, topY+1, leftX, bottomY-1);
  WinInvertLine (rightX, topY+1, rightX, bottomY-1);
  IF value <> 0 THEN
    BEGIN
    leftX := leftX + 1;
    rightX := rightX - 1;
    END;
  WinInvertLine (leftX, topY, rightX, topY);
  WinInvertLine (leftX, bottomY, rightX, bottomY);
  END
ELSE IF ctrlType = radioCtrl THEN
  BEGIN
  WinInvertCircleFrame
   (rect.topLeft.x + 1, rect.topLeft.y + 1, rect.extent.y - 2);
  END;
END;
.
